import se.datadosen.util.*;
import se.datadosen.tags.*;
import se.datadosen.jalbum.*;
import se.datadosen.util.Replacer;

String entityDecode(String s) {
	Replacer r = new Replacer();
	r.add("&lt;", "<");
	r.add("&gt;", ">");
	r.add("&amp;", "&");
	return r.replace(s);
}

void importComments(AlbumObject folder) throws IOException {	
	File outputDirectory = new File(rootOutputDirectory, folder.getPathFromRoot());
	String content = IO.readTextFile(new File(outputDirectory, "album.rss"));
	Section part = new Section(content);
	Element e;
	while ((e = Elements.getElementByName("item", part, false)) != null) {
		Element mediaContent = Elements.getElementByName("media:content", e.getContent(), false);
		File f = new File(mediaContent.getAttribute("url"));
		String comment = Elements.contentOfElement("description", e.getContent().toString());
		if (comment != null && comment.length() > 0) {
			AlbumObject child =  folder.getChild(f.getName());
			if (child !=  null) {
				child.setComment(comment);
			}
		}
		part = e.getPostElement();
	}
}

void processFolder(AlbumObject folder) {
	try {
		importComments(folder);
	}
	catch (IOException ex) {
		System.out.println("Can't import rss for folder " + folder);	
	}
	
	for (AlbumObject ao : folder.getChildren()) {		
		if (ao.isIncluded()) {
			if (ao.isFolder()) {
				processFolder(ao);	
			}	
		}	
	}	
}

msg =
"This tool will import comments found in the album.rss file of the currently made album\n" +
"Use this tool if you have accidently lost your comments, but have an intact album";

JOptionPane.showMessageDialog(window, msg, "Import comments from rss file", JOptionPane.INFORMATION_MESSAGE);

processFolder(rootFolder);

// Refresh UI so comments are loaded
window.albumExplorer.refreshAction.actionPerformed(null);
